/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.rendimientos;

import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.ats.modelo.obj.DetalleAir;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DetalleAirRendimiento
extends DetalleAir {
    private static final long serialVersionUID = 1453591463606297952L;
    public static final String C_TOTAL_DEPOSITO = "totalDeposito";
    @NotNull(message="Debe ingresar el valor de Total Dep\u00f3sito")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Total Dep\u00f3sito debe ser 12 enteros y 2 decimales. ")
    private String totalDeposito = "0.00";

    @Override
    protected ResultadoValidacion validarObjeto() {
        ResultadoValidacion resultado = new ResultadoValidacion();
        if (this.validarTotalDeposito(resultado).esEstadoFallido()) {
            return resultado;
        }
        if (!super.validarValorRetenido(resultado).esEstadoExitoso() && resultado.esEstadoFallido()) {
            return resultado;
        }
        return resultado.esEstadoExitoso() ? resultado.pasarValidacion() : resultado;
    }

    @Override
    public DetalleAirRendimiento crearCopiaEdicion() {
        DetalleAirRendimiento copia = new DetalleAirRendimiento();
        copia.setConceptoRetencion(super.getConceptoRetencion());
        copia.setDescripcionConcepto(super.getDescripcionConcepto());
        copia.setBaseImponibleRenta(super.getBaseImponibleRenta());
        copia.setValorRetenido(super.getValorRetenido());
        copia.setPorcentajeRetencion(super.getPorcentajeRetencion());
        copia.setTotalDeposito(this.totalDeposito);
        copia.setPropietario(this.propietario);
        return copia;
    }

    @Override
    public void actualizarInformacion(DetalleAir copiaEdicion) {
        DetalleAirRendimiento detalleAir = (DetalleAirRendimiento)copiaEdicion;
        this.setTotalDeposito(detalleAir.getTotalDeposito());
        super.actualizarInformacion(copiaEdicion);
    }

    private ResultadoValidacion validarTotalDeposito(ResultadoValidacion resultado) {
        if (Util.getBigDecimal(this.getTotalDeposito()).compareTo(Util.getBigDecimal(this.getBaseImponibleRenta())) == -1) {
            return resultado.fallarValidacion("El valor Total Deposito no puede ser menor al valor Base Imponible Renta");
        }
        return resultado;
    }

    @Override
    public Object importar(Element elemento, Map<String, Element> mapaData) {
        NodeList valorList = elemento.getElementsByTagName("codRetAir");
        Element eValor = (Element)valorList.item(0);
        this.setConceptoRetencion(eValor.getTextContent().trim());
        this.setDescripcionConcepto(String.valueOf(this.getConceptoRetencion()) + "-" + UtilCatalogosATS.crearInstancia().obtenerDescripcionRetencion(this.getConceptoRetencion(), ((Iva)this.getRaizModelo()).getDatosDeclaracion().getMes(), ((Iva)this.getRaizModelo()).getDatosDeclaracion().getAnio(), ((Iva)this.getRaizModelo()).getDatosDeclaracion().getMicro()));
        valorList = elemento.getElementsByTagName("baseImpAir");
        eValor = (Element)valorList.item(0);
        this.setBaseImponibleRenta(eValor.getTextContent().trim());
        valorList = elemento.getElementsByTagName("valRetAir");
        eValor = (Element)valorList.item(0);
        this.setValorRetenido(eValor.getTextContent().trim());
        valorList = elemento.getElementsByTagName("porcentajeAir");
        eValor = (Element)valorList.item(0);
        this.setPorcentajeRetencion(eValor.getTextContent().trim());
        valorList = elemento.getElementsByTagName("deposito");
        eValor = (Element)valorList.item(0);
        this.totalDeposito = eValor.getTextContent().trim();
        return this;
    }

    public String getTotalDeposito() {
        return this.totalDeposito;
    }

    public void setTotalDeposito(String totalDeposito) {
        String oldValue = this.totalDeposito;
        this.totalDeposito = totalDeposito;
        this.firePropertyChange(C_TOTAL_DEPOSITO, oldValue, this.totalDeposito);
    }

    public Element exportarDetalleAirREndimiento(Document document) {
        Element detalleAirRen = document.createElement("detalleAirRen");
        Element em = document.createElement("codRetAir");
        em.setTextContent(this.getConceptoRetencion());
        detalleAirRen.appendChild(em);
        em = document.createElement("deposito");
        em.setTextContent(this.getTotalDeposito());
        detalleAirRen.appendChild(em);
        em = document.createElement("baseImpAir");
        em.setTextContent(this.getBaseImponibleRenta());
        detalleAirRen.appendChild(em);
        em = document.createElement("porcentajeAir");
        em.setTextContent(this.getPorcentajeRetencion());
        detalleAirRen.appendChild(em);
        em = document.createElement("valRetAir");
        em.setTextContent(this.getValorRetenido());
        detalleAirRen.appendChild(em);
        return detalleAirRen;
    }
}

